from db import get_db


def get_row_count():
    return len(get_all())


def insert_song(name, singer):
    db = get_db()
    cursor = db.cursor()
    sql = "INSERT INTO songs(name, singer) VALUES (?, ?)"
    cursor.execute(sql, [name, singer])
    db.commit()
    return True


def get_by_id(key):
    db = get_db()
    cursor = db.cursor()
    sql = "SELECT id, name, singer FROM songs WHERE id = ?"
    cursor.execute(sql, [key])
    return cursor.fetchone()


def get_all():
    db = get_db()
    cursor = db.cursor()
    sql = "SELECT id, name, singer FROM songs"
    cursor.execute(sql)
    return cursor.fetchall()


def delete_by_id(key):
    db = get_db()
    cursor = db.cursor()

    item = get_by_id(key)
    if item is None:
        return False

    sql = "DELETE FROM songs WHERE id = ?"
    cursor.execute(sql, [key])
    db.commit()
    return True


def update_by_id(key, name, singer):
    db = get_db()
    cursor = db.cursor()

    item = get_by_id(key)
    if item is None:
        return False

    sql = "UPDATE songs SET name = ?, singer = ? WHERE id = ?"
    cursor.execute(sql, [name, singer, key])
    db.commit()
    return True
